# Course Material and FAQ for the Ultimate React Course

This branch of the repo contains starter files and final code for all sections and projects of the course, **exactly as shown in the videos**.

Use starter code to start each section, and **final code to compare it with your own code whenever something doesn't work**!

🚨 **_Please read the following Frequently Asked Questions (FAQ) carefully before starting the course_** 🚨

## FAQ

### Q1: How do I download the files?

**A:** If you just want to download the entire code, click the green button saying "Code", and then choose the "Download ZIP" option. If you can't see the button (on mobile), use [this link](https://github.com/jonasschmedtmann/ultimate-react-course/archive/main.zip) instead.

### Q2: I'm stuck! Where do I get help?

**A:** Have you tried to fix the problem on your own? **Have you compared your code with the final code?** Are you using the library versions as indicated in the course videos? If you failed fixing your problem, please **post a detailed description of the problem to the Q&A area of that video over at Udemy**, along with a link to a [codesandbox](https://codesandbox.io/) containing your code.

### Q3: Can I see a final version of the course projects?

**A:** Sure! Here you go:

- [Pizza Menu](https://fast-react-pizza-menu.netlify.app/) (Components, props, JSX)
- [Travel List](https://travel-list-jonas.netlify.app/) (useState and state management)
- [Eat-n-split](https://eat-n-split.netlify.app/) (Practice project)
- [usePopcorn](https://usepopcorn.netlify.app) (useEffect, data fetching, custom hooks)
- [Classy weather](https://classy-weather.netlify.app/) (Class components)
- [Quiz App](https://the-react-quiz.netlify.app/) (useReducer)
- [WorldWise](https://worldwise-jonas.netlify.app/) (React Router, context API, memo, useMemo, useCallback)
- [Fast React Pizza](https://fast-react-pizza.netlify.app/) (React Router data loading, Redux, Redux Toolkit, thunks, Tailwind CSS)
- [The Wild Oasis](https://the-wild-oasis.vercel.app) (React Query, Styled Components, React Hook Form, Supabase, advanced compound component pattern, authentication, charts, dark mode, professional application planning and development)
- [The Wild Oasis Website](https://the-wild-oasis-website.vercel.app/) (Next.js "app" router, React Server Components, server actions, authentication with NextAuth)

### Q4: What VSCode theme are you using?

**A:** I use [One Monokai](https://marketplace.visualstudio.com/items?itemName=azemoh.one-monokai) in this course. For the icons, I'm using [Material Icon Theme](https://marketplace.visualstudio.com/items?itemName=PKief.material-icon-theme).

### Q5: Videos don't load, can you fix it?

**A:** Unfortunately, there is nothing I can do about it. The course is hosted on Udemy, and sometimes they have technical issues. Please just come back a bit later or [contact their support team](https://support.udemy.com/hc/en-us).

### Q6: Videos are blurred / have low quality, can you fix it?

**A:** Please open video settings and change the quality from 'Auto' to another value, for example 720p. If that doesn't help, please [contact the Udemy support team](https://support.udemy.com/hc/en-us).

### Q7: Are videos downloadable?

**A:** Videos used to be downloadable, but unfortunately, Udemy has disabled video downloads on all my courses in order to fight piracy. There is nothing I can do about this.

### Q8: I want to put these projects in my portfolio. Is that allowed?

**A:** Absolutely! Just make sure you actually built them yourself by following the course, and that you understand what you did. What is **not allowed** is that you create your own course/videos/articles based on this course's content!

### Q9: I love your courses and want to get updates on new ones. How?

**A:** First, you can subscribe to my email list [at my website](http://codingheroes.io/resources). Plus, I make important announcements on twitter [@jonasschmedtman](https://twitter.com/jonasschmedtman), so you should definitely follow me there 🔥

### Q10: How do I get my certificate of completion?

**A:** A certificate of completion is provided by Udemy after you complete 100% of the course. After completing the course, just click on the "Your progress" indicator in the top right-hand corner of the course page. If you want to change your name on the certificate, please [contact the Udemy support team](https://support.udemy.com/hc/en-us).

### Q11: Can you add subtitles in my language?

**A:** No. I provide professional English captions, but Udemy is responsible for subtitles in all other languages (automatic translations). So please [contact the Udemy support team](https://support.udemy.com/hc/en-us) to request your own language.

### Q12: Do you accept pull requests?

**A:** No, because this repository should contain the _exact_ same code that is shown in the videos. _However, feel free to add an issue if you found one._
